<?php

namespace WhatsAppModule;

class JsonStorage
{
    private string $file;

    public function __construct(string $file)
    {
        $this->file = $file;

        if (!file_exists($this->file)) {
            file_put_contents($this->file, json_encode([], JSON_PRETTY_PRINT));
        }
    }

    public function append(array $data): void
    {
        $existing = json_decode(file_get_contents($this->file), true) ?? [];
        $existing[] = $data;

        file_put_contents(
            $this->file,
            json_encode($existing, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE)
        );
    }
}
